/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal;

import edu.sdsc.nbcr.common.TypeDeserializer;
import edu.sdsc.nbcr.opal.AppConfigInputType;
import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.AppMetadataInputType;
import edu.sdsc.nbcr.opal.AppMetadataType;
import edu.sdsc.nbcr.opal.AppServicePortType;
import edu.sdsc.nbcr.opal.ArgumentsType;
import edu.sdsc.nbcr.opal.BlockingOutputType;
import edu.sdsc.nbcr.opal.FaultType;
import edu.sdsc.nbcr.opal.InputFileType;
import edu.sdsc.nbcr.opal.JobInputType;
import edu.sdsc.nbcr.opal.JobOutputType;
import edu.sdsc.nbcr.opal.JobStatisticsType;
import edu.sdsc.nbcr.opal.JobSubOutputType;
import edu.sdsc.nbcr.opal.OutputFileType;
import edu.sdsc.nbcr.opal.OutputsByNameInputType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.SystemInfoInputType;
import edu.sdsc.nbcr.opal.SystemInfoType;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import edu.sdsc.nbcr.opal.manager.OpalJobManagerFactory;
import edu.sdsc.nbcr.opal.state.HibernateUtil;
import edu.sdsc.nbcr.opal.state.JobInfo;
import edu.sdsc.nbcr.opal.state.StateManagerException;
import edu.sdsc.nbcr.opal.util.ArgValidator;
import edu.sdsc.nbcr.opal.util.Extract;
import edu.sdsc.nbcr.opal.util.Util;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import java.sql.Time;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.log4j.Logger;

public class AppServiceImpl
implements AppServicePortType {
    private static Logger logger = Logger.getLogger((String)AppServiceImpl.class.getName());
    private static String catalinaHome;
    private static String outputPrefix;
    private static String tomcatURL;
    private static boolean archiveData;
    private static Hashtable jobTable;
    private static String jobManagerFQCN;
    private static boolean ipProcessing;
    private static long ipLimit;
    private static String[] blackListIP;
    private static String[] whiteListIP;
    private static String allowedDirsString;
    private static String[] allowedDirs;
    private String serviceName;
    private AppConfigType config;
    private File configFile;
    private long lastModified;
    Random rand = new Random();
    private static Properties props;

    public static String getOpalBaseURL() {
        try {
            URI uri = new URI(tomcatURL);
            return uri.resolve("/").toString() + "opal2";
        }
        catch (Exception e) {
            return null;
        }
    }

    public AppServiceImpl() throws FaultType {
        logger.debug((Object)"called");
        if (tomcatURL == null) {
            logger.fatal((Object)"Can't find property: tomcatURL");
            throw new FaultType("Can't find property: tomcatURL");
        }
        if (catalinaHome == null) {
            logger.fatal((Object)"Can't find property: catalina.home");
            throw new FaultType("Can't find property: catalina.home");
        }
    }

    @Override
    public AppMetadataType getAppMetadata(AppMetadataInputType in) throws FaultType {
        logger.debug((Object)"called");
        this.retrieveAppConfig();
        return this.config.getMetadata();
    }

    @Override
    public AppConfigType getAppConfig(AppConfigInputType in) throws FaultType {
        logger.debug((Object)"called");
        this.retrieveAppConfig();
        return this.config;
    }

    @Override
    public SystemInfoType getSystemInfo(SystemInfoInputType in) throws FaultType {
        logger.info((Object)"called");
        SystemInfoType result = new SystemInfoType();
        String className = "edu.sdsc.nbcr.opal.manager.";
        int start = className.length();
        int end = jobManagerFQCN.indexOf("JobManager");
        String jobManagerType = jobManagerFQCN.substring(start, end);
        result.setJobManagerType(jobManagerType);
        String dataLifeTime = props.getProperty("opal.datalifetime");
        if (dataLifeTime == null) {
            dataLifeTime = "4 days";
            logger.info((Object)"SystemInfoType: Using opal.datalifetime=4 days");
        }
        result.setDataLifetime(dataLifeTime);
        int hardLimit = 0;
        if (props.getProperty("opal.hard_limit") != null) {
            hardLimit = Integer.parseInt(props.getProperty("opal.hard_limit"));
            logger.info((Object)("SystemInfoType: Using hard limit " + hardLimit + " seconds"));
        }
        result.setHardLimit(hardLimit);
        int numCpuTotal = 1;
        if (props.getProperty("num.procs") != null) {
            numCpuTotal = Integer.parseInt(props.getProperty("num.procs"));
            logger.info((Object)("SystemInfoType: Using num.procs = " + numCpuTotal));
        }
        result.setNumCpuTotal(numCpuTotal);
        long numJobsExec = 0L;
        try {
            numJobsExec = HibernateUtil.getNumExecutingJobs();
        }
        catch (StateManagerException sme) {
            String msg = sme.getMessage();
            logger.error((Object)msg);
            throw new FaultType(msg);
        }
        result.setNumJobsRunning((int)numJobsExec);
        long numJobsPending = 0L;
        try {
            numJobsExec = HibernateUtil.getNumPendingJobs();
        }
        catch (StateManagerException sme) {
            String msg = sme.getMessage();
            logger.error((Object)msg);
            throw new FaultType(msg);
        }
        result.setNumJobsQueued((int)numJobsPending);
        int numCpuFree = numCpuTotal - (int)numJobsExec - (int)numJobsPending;
        if (numCpuFree < 0) {
            numCpuFree = 0;
        }
        result.setNumCpuFree(numCpuFree);
        return result;
    }

    @Override
    public JobSubOutputType launchJob(JobInputType in) throws FaultType {
        long t0 = System.currentTimeMillis();
        logger.debug((Object)"called");
        this.isWithinIPLimits();
        this.retrieveAppConfig();
        String jobID = this.launchApp(in, false);
        JobSubOutputType output = new JobSubOutputType();
        output.setJobID(jobID);
        logger.info((Object)("Launching job: " + jobID));
        StatusOutputType status = this.queryStatus(jobID);
        output.setStatus(status);
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Server execution time: " + (t1 - t0) + " ms"));
        return output;
    }

    @Override
    public BlockingOutputType launchJobBlocking(JobInputType in) throws FaultType {
        long t0 = System.currentTimeMillis();
        logger.info((Object)"called");
        this.isWithinIPLimits();
        this.retrieveAppConfig();
        String jobID = this.launchApp(in, true);
        BlockingOutputType output = new BlockingOutputType();
        StatusOutputType status = this.queryStatus(jobID);
        output.setStatus(status);
        JobOutputType jobOut = this.getOutputs(jobID);
        output.setJobOut(jobOut);
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Server execution time: " + (t1 - t0) + " ms"));
        return output;
    }

    @Override
    public StatusOutputType queryStatus(String in) throws FaultType {
        long t0 = System.currentTimeMillis();
        logger.debug((Object)("Query status for job: " + in));
        StatusOutputType status = null;
        try {
            status = HibernateUtil.getStatus(in);
        }
        catch (StateManagerException se) {
            logger.error((Object)se.getMessage());
            throw new FaultType(se.getMessage());
        }
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Query execution time: " + (t1 - t0) + " ms"));
        return status;
    }

    @Override
    public JobStatisticsType getJobStatistics(String in) throws FaultType {
        long t0 = System.currentTimeMillis();
        logger.info((Object)("called for job: " + in));
        JobStatisticsType stats = null;
        try {
            stats = HibernateUtil.getStatistics(in);
        }
        catch (StateManagerException se) {
            logger.error((Object)se.getMessage());
            throw new FaultType(se.getMessage());
        }
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Query execution time: " + (t1 - t0) + " ms"));
        return stats;
    }

    @Override
    public JobOutputType getOutputs(String in) throws FaultType {
        long t0 = System.currentTimeMillis();
        logger.info((Object)("called for job: " + in));
        JobOutputType outputs = null;
        try {
            outputs = HibernateUtil.getOutputs(in);
        }
        catch (StateManagerException se) {
            logger.error((Object)se.getMessage());
            throw new FaultType(se.getMessage());
        }
        File test = new File(outputPrefix + File.separator + in);
        if (!test.exists()) {
            logger.error((Object)"Job outputs have been cleaned up");
            throw new FaultType("Job outputs have been cleaned up");
        }
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Output retrieval time: " + (t1 - t0) + " ms"));
        return outputs;
    }

    @Override
    public byte[] getOutputAsBase64ByName(OutputsByNameInputType in) throws FaultType {
        long t0 = System.currentTimeMillis();
        logger.info((Object)("called for job: " + in.getJobID() + " with file name: " + in.getFileName()));
        byte[] data = null;
        String outputDirName = outputPrefix + File.separator + in.getJobID() + File.separator;
        String outputURL = outputDirName + in.getFileName();
        File f = new File(outputURL);
        if (f.exists()) {
            try {
                data = new byte[(int)f.length()];
                FileInputStream fIn = new FileInputStream(f);
                fIn.read(data);
                fIn.close();
            }
            catch (Exception e) {
                logger.error((Object)("Error while trying to read output: " + e.getMessage()));
                throw new FaultType("Error while trying to read output: " + e.getMessage());
            }
        } else {
            logger.error((Object)("File " + in.getFileName() + " doesn't exist on server"));
            throw new FaultType("File " + in.getFileName() + " doesn't exist on server");
        }
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Output retrieval time: " + (t1 - t0) + " ms"));
        return data;
    }

    @Override
    public StatusOutputType destroy(String in) throws FaultType {
        long t0 = System.currentTimeMillis();
        logger.info((Object)("called for job: " + in));
        StatusOutputType status = null;
        if (jobTable.containsKey(in)) {
            OpalJobManager jobManager = (OpalJobManager)jobTable.get(in);
            try {
                status = jobManager.destroyJob();
            }
            catch (JobManagerException jme) {
                String msg = jme.getMessage();
                logger.error((Object)msg);
                throw new FaultType(msg);
            }
        } else {
            status = this.queryStatus(in);
        }
        if (status.getBaseURL() == null) {
            try {
                org.apache.axis.types.URI baseURL = new org.apache.axis.types.URI(tomcatURL + in);
                status.setBaseURL(baseURL);
            }
            catch (Exception e) {
                String message = "Exception while trying to construct base URL";
                logger.error((Object)message);
                throw new FaultType(message);
            }
        }
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("Destruction time: " + (t1 - t0) + " ms"));
        return status;
    }

    private String launchApp(JobInputType in, boolean blocking) throws FaultType {
        String handle;
        OpalJobManager jobManager;
        org.apache.axis.types.URI baseURL;
        final String jobID = "app" + this.serviceName + System.currentTimeMillis() + this.rand.nextInt();
        final String outputDirName = outputPrefix + File.separator + jobID + File.separator;
        File outputDir = new File(outputDirName);
        if (!outputDir.mkdir()) {
            logger.error((Object)("Can't create new directory to run application in" + outputDir));
            throw new FaultType("Can't create new directory to run application in" + outputDir);
        }
        this.writeAppInput(in, outputDirName);
        String args = in.getArgList();
        if (args != null) {
            StringTokenizer argTokens = new StringTokenizer(args);
            while (argTokens.hasMoreTokens()) {
                String next = argTokens.nextToken();
                if (next.startsWith(File.separator) || next.startsWith("~")) {
                    boolean allowed = false;
                    for (int i = 0; i < allowedDirs.length; ++i) {
                        if (!next.startsWith(allowedDirs[i])) continue;
                        allowed = true;
                        break;
                    }
                    if (!allowed) {
                        String msg = "Arguments are not allowed to begin with: " + File.separator + " or " + "~";
                        logger.error((Object)msg);
                        throw new FaultType(msg);
                    }
                }
                if (next.indexOf("..") == -1) continue;
                String msg = "Arguments are not allowed to include: ..";
                logger.error((Object)msg);
                throw new FaultType(msg);
            }
        }
        if (this.config.getValidateArgs() != null && this.config.getValidateArgs().booleanValue()) {
            logger.info((Object)"Validating command-line arguments");
            ArgumentsType argsDesc = this.config.getMetadata().getTypes();
            if (argsDesc == null) {
                String msg = "Validation of arguments requested - but argument schema not provided within app config";
                logger.error((Object)msg);
                throw new FaultType(msg);
            }
            ArgValidator av = new ArgValidator(argsDesc);
            boolean success = av.validateArgList(outputDirName, in.getArgList());
            if (success) {
                logger.info((Object)"Argument validation successful");
            } else {
                String msg = "Argument validation unsuccessful";
                logger.error((Object)msg);
                throw new FaultType(msg);
            }
        }
        StatusOutputType status = new StatusOutputType();
        status.setCode(1);
        status.setMessage("Launching executable");
        try {
            baseURL = new org.apache.axis.types.URI(tomcatURL + jobID);
            status.setBaseURL(baseURL);
        }
        catch (Exception e) {
            String message = "Exception while trying to construct base URL";
            logger.error((Object)message);
            throw new FaultType(message);
        }
        JobInfo info = new JobInfo();
        info.setJobID(jobID);
        info.setCode(status.getCode());
        info.setMessage(status.getMessage());
        info.setBaseURL(status.getBaseURL().toString());
        java.util.Date currentDate = new java.util.Date();
        info.setStartTimeDate(new Date(currentDate.getTime()));
        info.setStartTimeTime(new Time(currentDate.getTime()));
        info.setLastUpdateDate(new Date(currentDate.getTime()));
        info.setLastUpdateTime(new Time(currentDate.getTime()));
        info.setClientDN(Util.getRemoteDN());
        info.setClientIP(Util.getRemoteIP());
        info.setServiceName(this.serviceName);
        final String userEmail = in.getUserEmail();
        if (userEmail != null) {
            logger.debug((Object)("User email for notification: " + userEmail));
            info.setUserEmail(userEmail);
        } else {
            info.setUserEmail("Unknown");
        }
        try {
            HibernateUtil.saveJobInfoInDatabase(info);
        }
        catch (StateManagerException se) {
            logger.error((Object)se.getMessage());
            throw new FaultType(se.getMessage());
        }
        String jobManagerFQCNLocal = jobManagerFQCN;
        if (this.config.getJobManagerFQCN() != null) {
            jobManagerFQCNLocal = this.config.getJobManagerFQCN();
        }
        logger.debug((Object)("Using job manager class: " + jobManagerFQCNLocal));
        try {
            jobManager = OpalJobManagerFactory.getOpalJobManager(jobManagerFQCNLocal);
        }
        catch (JobManagerException jme) {
            logger.error((Object)jme.getMessage());
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, 4, jme.getMessage(), info.getBaseURL(), null);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            throw new FaultType(jme.getMessage());
        }
        try {
            jobManager.initialize(props, this.config, null);
        }
        catch (JobManagerException jme) {
            logger.error((Object)jme.getMessage());
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, 4, jme.getMessage(), info.getBaseURL(), null);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            throw new FaultType(jme.getMessage());
        }
        try {
            handle = jobManager.launchJob(in.getArgList(), in.getNumProcs(), outputDirName);
        }
        catch (JobManagerException jme) {
            logger.error((Object)jme.getMessage());
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, 4, jme.getMessage(), info.getBaseURL(), null);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            throw new FaultType(jme.getMessage());
        }
        jobTable.put(jobID, jobManager);
        final Boolean sendNotification = in.getSendNotification();
        if (!blocking) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        AppServiceImpl.this.manageJob(jobManager, jobID, outputDirName, baseURL, handle);
                    }
                    catch (FaultType f) {
                        logger.error((Object)f);
                    }
                    if (sendNotification != null && sendNotification.booleanValue()) {
                        if (userEmail != null) {
                            AppServiceImpl.this.emailStatus(userEmail, jobID);
                        } else {
                            logger.error((Object)"Can't send email to user as email is NULL");
                        }
                    }
                }
            }.start();
        } else {
            try {
                this.manageJob(jobManager, jobID, outputDirName, baseURL, handle);
            }
            catch (FaultType f) {
                if (sendNotification != null && sendNotification.booleanValue()) {
                    if (userEmail != null) {
                        this.emailStatus(userEmail, jobID);
                    } else {
                        logger.error((Object)"Can't send email to user as email is NULL");
                    }
                }
                throw f;
            }
            if (sendNotification != null && sendNotification.booleanValue()) {
                if (userEmail != null) {
                    this.emailStatus(userEmail, jobID);
                } else {
                    logger.error((Object)"Can't send email to user as email is NULL");
                }
            }
        }
        return jobID;
    }

    private void manageJob(OpalJobManager jobManager, String jobID, String workingDir, org.apache.axis.types.URI baseURL, String handle) throws FaultType {
        StatusOutputType status = null;
        try {
            status = jobManager.waitForActivation();
        }
        catch (JobManagerException jme) {
            logger.error((Object)jme.getMessage());
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, 4, jme.getMessage(), baseURL.toString(), handle);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            throw new FaultType(jme.getMessage());
        }
        if (status.getBaseURL() == null) {
            status.setBaseURL(baseURL);
        }
        try {
            HibernateUtil.updateJobInfoInDatabase(jobID, status.getCode(), status.getMessage(), status.getBaseURL().toString(), new java.util.Date(), null, handle);
        }
        catch (StateManagerException se) {
            logger.error((Object)se.getMessage());
            throw new FaultType(se.getMessage());
        }
        try {
            status = jobManager.waitForCompletion();
        }
        catch (JobManagerException jme) {
            logger.error((Object)jme.getMessage());
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, 4, jme.getMessage(), status.getBaseURL().toString(), handle);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            throw new FaultType(jme.getMessage());
        }
        if (status.getBaseURL() == null) {
            status.setBaseURL(baseURL);
        }
        int jobCode = status.getCode();
        String jobMessage = status.getMessage();
        status.setCode(128);
        status.setMessage("Writing output metadata");
        try {
            HibernateUtil.updateJobInfoInDatabase(jobID, status.getCode(), status.getMessage(), status.getBaseURL().toString(), handle);
        }
        catch (StateManagerException se) {
            logger.error((Object)se.getMessage());
            throw new FaultType(se.getMessage());
        }
        File stdOutFile = new File(workingDir + File.separator + "stdout.txt");
        if (!stdOutFile.exists()) {
            String msg = "Standard output file " + stdOutFile + " is missing";
            logger.error((Object)msg);
            status.setCode(4);
            status.setMessage(msg);
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, status.getCode(), status.getMessage(), status.getBaseURL().toString(), handle);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            jobTable.remove(jobID);
            return;
        }
        File stdErrFile = new File(workingDir + File.separator + "stderr.txt");
        if (!stdErrFile.exists()) {
            String msg = "Standard error file " + stdErrFile + " is missing";
            logger.error((Object)msg);
            status.setCode(4);
            status.setMessage(msg);
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, status.getCode(), status.getMessage(), status.getBaseURL().toString(), handle);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            jobTable.remove(jobID);
            return;
        }
        if (archiveData) {
            logger.debug((Object)"Archiving output files");
            File f = new File(workingDir);
            File[] outputFiles = this.getAllOutputs(workingDir);
            byte[] buf = new byte[1024];
            try {
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(workingDir + File.separator + jobID + ".zip"));
                for (int i = 0; i < outputFiles.length; ++i) {
                    int len;
                    FileInputStream in = new FileInputStream(outputFiles[i]);
                    String absolutePath = outputFiles[i].getPath();
                    int start = absolutePath.indexOf(jobID);
                    String relativePath = absolutePath.substring(start + jobID.length() + 1);
                    out.putNextEntry(new ZipEntry(relativePath));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
                logger.error((Object)"Error not fatal - moving on");
            }
        }
        JobOutputType outputs = new JobOutputType();
        try {
            File f = new File(workingDir);
            File[] outputFiles = this.getAllOutputs(workingDir);
            int count = 0;
            OutputFileType[] outputFileObj = null;
            for (int i = 0; i < outputFiles.length; ++i) {
                if (!outputFiles[i].getAbsolutePath().equals(stdOutFile.getAbsolutePath()) && !outputFiles[i].getAbsolutePath().equals(stdErrFile.getAbsolutePath())) continue;
                ++count;
            }
            if (count == 2) {
                outputFileObj = new OutputFileType[outputFiles.length - 2];
            } else if (count == 1) {
                outputFileObj = new OutputFileType[outputFiles.length - 1];
            } else if (count == 0) {
                outputFileObj = new OutputFileType[outputFiles.length];
            }
            int j = 0;
            for (int i = 0; i < outputFiles.length; ++i) {
                if (outputFiles[i].getAbsolutePath().equals(stdOutFile.getAbsolutePath())) {
                    outputs.setStdOut(new org.apache.axis.types.URI(tomcatURL + jobID + "/stdout.txt"));
                    continue;
                }
                if (outputFiles[i].getAbsolutePath().equals(stdErrFile.getAbsolutePath())) {
                    outputs.setStdErr(new org.apache.axis.types.URI(tomcatURL + jobID + "/stderr.txt"));
                    continue;
                }
                OutputFileType next = new OutputFileType();
                String absolutePath = outputFiles[i].getPath();
                int start = absolutePath.indexOf(jobID);
                String relativePath = absolutePath.substring(start + jobID.length() + 1);
                next.setName(relativePath);
                next.setUrl(new org.apache.axis.types.URI(tomcatURL + jobID + "/" + relativePath));
                outputFileObj[j++] = next;
            }
            outputs.setOutputFile(outputFileObj);
            try {
                HibernateUtil.saveOutputsInDatabase(jobID, outputs);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            status.setCode(4);
            status.setMessage("Cannot retrieve outputs after finish - " + e.getMessage());
            try {
                HibernateUtil.updateJobInfoInDatabase(jobID, status.getCode(), status.getMessage(), status.getBaseURL().toString(), handle);
            }
            catch (StateManagerException se) {
                logger.error((Object)se.getMessage());
                throw new FaultType(se.getMessage());
            }
            jobTable.remove(jobID);
            return;
        }
        status.setCode(jobCode);
        status.setMessage(jobMessage);
        try {
            HibernateUtil.updateJobInfoInDatabase(jobID, status.getCode(), status.getMessage(), status.getBaseURL().toString(), null, new java.util.Date(), handle);
        }
        catch (StateManagerException se) {
            logger.error((Object)se.getMessage());
            throw new FaultType(se.getMessage());
        }
        jobTable.remove(jobID);
        logger.info((Object)("Execution complete for job: " + jobID));
    }

    private void writeAppInput(JobInputType in, String outputDirName) throws FaultType {
        logger.debug((Object)"called");
        InputFileType[] inputFiles = in.getInputFile();
        if (inputFiles == null) {
            logger.debug((Object)"No input files to be written out");
            return;
        }
        logger.debug((Object)("Number of input files to be written out: " + inputFiles.length));
        for (int i = 0; i < inputFiles.length; ++i) {
            if (inputFiles[i].getContents() == null && inputFiles[i].getLocation() == null && inputFiles[i].getAttachment() == null) {
                String msg = "File contents, URL and attachment are missing - one of them should be provided";
                logger.error((Object)msg);
                throw new FaultType(msg);
            }
            this.writeInputFile(outputDirName, inputFiles[i], in.getExtractInputs());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeInputFile(String outputDirName, InputFileType inputFile, Boolean extractInputs) throws FaultType {
        logger.debug((Object)("called for file: " + inputFile.getName()));
        try {
            File f = new File(outputDirName + File.separator + inputFile.getName());
            BufferedOutputStream out = null;
            if (inputFile.getContents() != null) {
                out = new BufferedOutputStream(new FileOutputStream(f));
                out.write(inputFile.getContents());
                out.close();
            } else if (inputFile.getLocation() != null) {
                int numRead;
                int index = inputFile.getLocation().toString().indexOf(":");
                if (index == -1) {
                    String msg = "Can't find protocol for URL: " + inputFile.getLocation();
                    logger.error((Object)msg);
                    throw new FaultType(msg);
                }
                out = new BufferedOutputStream(new FileOutputStream(f));
                String protocol = inputFile.getLocation().toString().substring(0, index);
                logger.info((Object)("Using protocol: " + protocol));
                if (!protocol.equals("http") && !protocol.equals("https")) {
                    String msg = "Unsupported protocol: " + protocol;
                    logger.error((Object)msg);
                    throw new FaultType(msg);
                }
                URL url = new URL(inputFile.getLocation().toString());
                URLConnection conn = url.openConnection();
                InputStream input = conn.getInputStream();
                byte[] buffer = new byte[1024];
                long numWritten = 0L;
                while ((numRead = input.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    numWritten += (long)numRead;
                }
                logger.debug((Object)(numWritten + " bytes written from url: " + inputFile.getLocation()));
                input.close();
                out.close();
            } else {
                DataHandler dh = inputFile.getAttachment();
                logger.debug((Object)("Received attachment: " + dh.getName()));
                File attachFile = new File(dh.getName());
                logger.debug((Object)("Source is " + attachFile.toString() + " and dest is " + f.toString()));
                try {
                    attachFile.renameTo(f);
                }
                catch (Exception e) {
                    String msg = "Unable to copy attachment correctly: " + dh.getName();
                    logger.error((Object)msg);
                    throw new FaultType(msg);
                }
            }
            if (extractInputs == null) return;
            if (extractInputs == false) return;
            logger.debug((Object)("Trying to extract file: " + f.getName()));
            Extract ex = new Extract();
            ex.extract(outputDirName, f.getAbsolutePath());
            f.delete();
            return;
        }
        catch (FaultType f) {
            throw f;
        }
        catch (IOException ioe) {
            logger.error((Object)("IOException while trying to write input file: " + ioe.getMessage()));
            throw new FaultType("IOException while trying to write input file: " + ioe.getMessage());
        }
    }

    private void retrieveAppConfig() throws FaultType {
        long newLastModified;
        String configFileName;
        logger.debug((Object)"called");
        MessageContext mc = MessageContext.getCurrentContext();
        SOAPService service = mc.getService();
        this.serviceName = service.getName();
        if (this.serviceName == null) {
            this.serviceName = "Unknown service";
        }
        if ((configFileName = (String)service.getOption("appConfig")) == null) {
            logger.error((Object)"Required parameter appConfig not found in WSDD");
            throw new FaultType("Required parameter appConfig not found in WSDD");
        }
        boolean reconfigure = false;
        if (this.configFile == null) {
            this.configFile = new File(configFileName);
            this.lastModified = this.configFile.lastModified();
        }
        if ((newLastModified = this.configFile.lastModified()) > this.lastModified) {
            reconfigure = true;
            this.lastModified = newLastModified;
            logger.info((Object)"Application config modified recently -- reconfiguring");
        }
        if (this.config == null) {
            reconfigure = true;
            logger.debug((Object)"Configuring service for the first time");
        }
        if (reconfigure) {
            logger.info((Object)("Reading application config: " + configFileName));
            try {
                this.config = (AppConfigType)TypeDeserializer.getValue(configFileName, new AppConfigType());
            }
            catch (Exception e) {
                logger.error((Object)e);
                String msg = "Can't read application configuration from XML for service: " + this.serviceName;
                logger.error((Object)msg);
                throw new FaultType(msg);
            }
        }
    }

    private File[] getAllOutputs(String workingDir) throws FaultType {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean a = true;
                try {
                    a = file.canRead() && file.getAbsolutePath().equals(file.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
                return a;
            }
        };
        File wd = new File(workingDir);
        File[] top_files = wd.listFiles(fileFilter);
        Stack<File> checks = new Stack<File>();
        Stack<File> ofs = new Stack<File>();
        for (int i = 0; i < top_files.length; ++i) {
            checks.push(top_files[i]);
        }
        while (!checks.empty()) {
            File temp_file = (File)checks.pop();
            if (temp_file.isDirectory()) {
                File[] dir_files = temp_file.listFiles(fileFilter);
                for (int i = 0; i < dir_files.length; ++i) {
                    checks.push(dir_files[i]);
                }
                continue;
            }
            ofs.push(temp_file);
        }
        int numFiles = ofs.size();
        File[] outputFiles = new File[numFiles];
        int c = 0;
        while (!ofs.empty()) {
            File of;
            outputFiles[c] = of = (File)ofs.pop();
            ++c;
        }
        return outputFiles;
    }

    private boolean isWithinIPLimits() throws FaultType {
        int i;
        logger.debug((Object)"called");
        if (!ipProcessing) {
            return true;
        }
        String remoteIP = Util.getRemoteIP();
        logger.debug((Object)("Request received from IP: " + remoteIP));
        for (i = 0; i < blackListIP.length; ++i) {
            if (!remoteIP.equals(blackListIP[i])) continue;
            String msg = "Remote IP " + remoteIP + " found in blacklist";
            logger.error((Object)msg);
            throw new FaultType(msg);
        }
        for (i = 0; i < whiteListIP.length; ++i) {
            if (!remoteIP.equals(whiteListIP[i])) continue;
            logger.debug((Object)("Remote IP " + remoteIP + " found in whitelist"));
            return true;
        }
        long numJobsIP = 0L;
        try {
            numJobsIP = HibernateUtil.getNumJobsThisHour(remoteIP);
        }
        catch (StateManagerException sme) {
            String msg = sme.getMessage();
            logger.error((Object)msg);
            throw new FaultType(msg);
        }
        if (numJobsIP < ipLimit) {
            logger.debug((Object)("Number of jobs (" + numJobsIP + ") for client (" + remoteIP + ") is within limit"));
            return true;
        }
        String msg = "Number of jobs (" + numJobsIP + ") for client (" + remoteIP + ") at maximum limit (" + ipLimit + " per hour)";
        logger.error((Object)msg);
        throw new FaultType(msg);
    }

    private void emailStatus(String userEmail, String jobID) {
        try {
            logger.info((Object)"called");
            boolean emailEnabled = Boolean.valueOf(props.getProperty("mail.enable"));
            if (!emailEnabled) {
                logger.warn((Object)"Opal server is not enabled to send email to user");
                return;
            }
            StatusOutputType status = this.queryStatus(jobID);
            Properties mailProps = new Properties();
            String mailServer = props.getProperty("mail.smtp.host");
            if (mailServer == null) {
                logger.error((Object)"No mail server specified in opal.properties");
                return;
            }
            mailProps.put("mail.smtp.host", mailServer);
            SMTPAuthenticator auth = null;
            String enableAuth = props.getProperty("mail.smtp.auth");
            if (enableAuth != null && enableAuth.equals("true")) {
                mailProps.put("mail.smtp.starttls.enable", enableAuth);
                mailProps.put("mail.smtp.auth", enableAuth);
                String userName = props.getProperty("mail.smtp.user");
                String password = props.getProperty("mail.smtp.password");
                if (userName == null || password == null) {
                    logger.error((Object)"Username/password for SMTP server is null");
                    return;
                }
                auth = new SMTPAuthenticator(userName, password);
            }
            Session session = Session.getDefaultInstance((Properties)mailProps, auth);
            Boolean debug = Boolean.parseBoolean(props.getProperty("mail.smtp.debug"));
            session.setDebug(debug.booleanValue());
            MimeMessage msg = new MimeMessage(session);
            String userFrom = props.getProperty("mail.smtp.from");
            if (userFrom == null) {
                logger.error((Object)"Can't find a FROM email address in the opal.properties");
                return;
            }
            InternetAddress addressFrom = new InternetAddress(userFrom);
            msg.setFrom((Address)addressFrom);
            InternetAddress[] addressTo = new InternetAddress[]{new InternetAddress(userEmail)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
            msg.setSubject("Results for Opal job: " + jobID);
            String body = "Your Opal job is complete\n\nJob ID: " + jobID + "\n" + "Status code: " + status.getCode() + "\n" + "Message: " + status.getMessage() + "\n" + "Output Base URL: " + status.getBaseURL() + "\n";
            msg.setContent((Object)body, "text/plain");
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            String msg = "Exception caught while trying to email user: " + e.getMessage();
            logger.error((Object)msg);
        }
    }

    static {
        jobTable = new Hashtable();
        props = new Properties();
        String propsFileName = "opal.properties";
        try {
            props.load(AppServiceImpl.class.getClassLoader().getResourceAsStream(propsFileName));
        }
        catch (IOException ioe) {
            logger.fatal((Object)"Failed to load opal.properties");
        }
        tomcatURL = props.getProperty("tomcat.url") + "/";
        catalinaHome = System.getProperty("catalina.home");
        outputPrefix = catalinaHome + File.separator + "webapps" + File.separator;
        String workingDir = props.getProperty("working.dir");
        if (workingDir != null) {
            outputPrefix = outputPrefix + workingDir;
            if (tomcatURL != null) {
                tomcatURL = tomcatURL + workingDir + "/";
            }
        } else {
            outputPrefix = outputPrefix + "ROOT";
        }
        try {
            File prefixDir = new File(outputPrefix);
            outputPrefix = prefixDir.getCanonicalPath();
        }
        catch (IOException e) {
            logger.fatal((Object)e);
        }
        archiveData = Boolean.valueOf(props.getProperty("data.archive"));
        if (archiveData) {
            logger.info((Object)"Data will be available as archive after job completion");
        }
        try {
            logger.debug((Object)"Checking if there are any zombie jobs");
            int numUpdates = HibernateUtil.markZombieJobs();
            logger.debug((Object)("Number of DB entries for zombie jobs cleaned up: " + numUpdates));
        }
        catch (StateManagerException se) {
            logger.fatal((Object)"Caught exception while trying to clean database", (Throwable)se);
        }
        jobManagerFQCN = props.getProperty("opal.jobmanager");
        if (jobManagerFQCN == null) {
            logger.fatal((Object)"Required property not set - opal.jobmanager");
        }
        if (!(ipProcessing = Boolean.valueOf(props.getProperty("opal.ip.processing")).booleanValue())) {
            logger.debug((Object)"Upper limits per IP not turned on");
        } else {
            String ipLimitString = props.getProperty("opal.ip.limit");
            if (ipLimitString == null) {
                logger.fatal((Object)"Unable to find a limit for number of jobs per IP");
                ipLimit = 0L;
            } else {
                ipLimit = Long.parseLong(ipLimitString);
                logger.debug((Object)("Number of jobs per IP per hour: " + ipLimit));
            }
            String blackListString = props.getProperty("opal.ip.blacklist");
            blackListIP = blackListString != null ? blackListString.split("\\s*,\\s*") : new String[0];
            String whiteListString = props.getProperty("opal.ip.whitelist");
            whiteListIP = whiteListString != null ? whiteListString.split("\\s*,\\s*") : new String[0];
        }
        allowedDirsString = props.getProperty("allowed.path.prefixes");
        allowedDirs = allowedDirsString != null ? allowedDirsString.split("\\s*,\\s*") : new String[0];
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        SMTPAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

