/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.dashboard.persistence;

import edu.sdsc.nbcr.opal.dashboard.util.DateHelper;
import edu.sdsc.nbcr.opal.state.HibernateUtil;
import java.sql.Date;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.type.Type;

public class DBManager {
    protected static Log log = LogFactory.getLog((String)DBManager.class.getName());
    private String error = null;
    private String driver = null;
    private String dialect = null;
    private SessionFactory sessionFactory = HibernateUtil.getSessionFactory();
    private boolean isConnected = true;

    public DBManager() {
        try {
            Session session = this.sessionFactory.openSession();
            this.driver = session.connection().getMetaData().getDriverName();
            session.close();
        }
        catch (Exception e) {
            this.isConnected = false;
            e.printStackTrace();
        }
        SessionFactoryImpl factoryimpl = (SessionFactoryImpl)this.sessionFactory;
        this.dialect = factoryimpl.getDialect().getClass().getName();
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDialect() {
        return this.dialect;
    }

    public boolean init() {
        return true;
    }

    public boolean isConnected() {
        if (this.isConnected) {
            return true;
        }
        try {
            Session session = this.sessionFactory.openSession();
            this.driver = session.connection().getMetaData().getDriverName();
            session.close();
            this.isConnected = true;
        }
        catch (Exception e) {
            this.isConnected = false;
            e.printStackTrace();
        }
        return this.isConnected;
    }

    public String[] getServicesList() {
        String baseName = null;
        Session session = this.sessionFactory.openSession();
        List serviceList = null;
        serviceList = session.createQuery("select serviceName from ServiceStatus where status='ACTIVE' group by serviceName ").list();
        session.close();
        Iterator itera = serviceList.iterator();
        HashSet<String> returnList = new HashSet<String>();
        while (itera.hasNext()) {
            String fullName = (String)itera.next();
            String[] splitName = fullName.split("_");
            String version = splitName[splitName.length - 1];
            if (this.isVersion(version) && version.length() < fullName.length()) {
                int endIndex = fullName.length() - version.length() - 1;
                baseName = fullName.substring(0, endIndex);
            } else {
                baseName = fullName;
            }
            returnList.add(baseName);
        }
        Object[] returnArray = returnList.toArray(new String[returnList.size()]);
        Arrays.sort(returnArray);
        return returnArray;
    }

    public double[] getHits(java.util.Date startDate, java.util.Date endDate, String service) {
        return this.getResultsTimeseries(startDate, endDate, service, "hits");
    }

    public double[] getError(java.util.Date startDate, java.util.Date endDate, String service) {
        return this.getResultsTimeseries(startDate, endDate, service, "error");
    }

    public double[] getExectime(java.util.Date startDate, java.util.Date endDate, String service) {
        return this.getResultsTimeseries(startDate, endDate, service, "exectime");
    }

    public double[] getResultsTimeseries(java.util.Date startDate, java.util.Date endDate, String service, String type) {
        Session session = this.sessionFactory.openSession();
        int numberOfDays = DateHelper.getOffsetDays(endDate, startDate);
        if (numberOfDays < 0) {
            log.error((Object)"The start date is later than the end date.");
            return null;
        }
        Date endDateSQL = new Date(endDate.getTime());
        Date startDateSQL = new Date(startDate.getTime());
        Query queryStat = null;
        String query = null;
        if (type.equals("hits")) {
            query = "select jobInfo.startTimeDate, count(*)   from JobInfo jobInfo where jobInfo.serviceName like :service and jobInfo.startTimeDate >= :startDate  and jobInfo.startTimeDate <= :endDate  and jobInfo.code=8  group by jobInfo.startTimeDate  order by jobInfo.startTimeDate desc";
            queryStat = session.createQuery(query);
        } else if (type.equals("exectime")) {
            query = this.getQueryExectime();
            if (query != null) {
                SQLQuery sqlQuery = session.createSQLQuery(query);
                sqlQuery.addScalar("date", (Type)Hibernate.DATE);
                sqlQuery.addScalar("average", (Type)Hibernate.DOUBLE);
                queryStat = sqlQuery;
            } else {
                queryStat = session.getNamedQuery("exectime");
            }
        } else if (type.equals("error")) {
            query = "select jobInfo.startTimeDate, count(*) from JobInfo jobInfo where jobInfo.serviceName like :service and jobInfo.startTimeDate >= :startDate and jobInfo.startTimeDate <= :endDate and jobInfo.code=4 group by jobInfo.startTimeDate order by jobInfo.startTimeDate desc ";
            queryStat = session.createQuery(query);
        }
        try {
            queryStat.setString("service", service + "%").setDate("startDate", (java.util.Date)startDateSQL).setDate("endDate", (java.util.Date)endDateSQL);
            List result = queryStat.list();
            Iterator itera = result.iterator();
            log.debug((Object)("Going to get the " + type + " for the service: " + service + "\nRunning the following query: " + queryStat.getQueryString()));
            double[] values = new double[numberOfDays + 1];
            int counter = numberOfDays;
            java.util.Date currentDate = endDate;
            while (itera.hasNext()) {
                Object[] entry = (Object[])itera.next();
                Date date = (Date)entry[0];
                while (!DateHelper.compareDates(currentDate, date) && counter != -1) {
                    values[counter] = 0.0;
                    log.trace((Object)("Inserting a zero for date: " + currentDate + " on position: " + counter));
                    --counter;
                    currentDate = DateHelper.subtractDay(currentDate);
                }
                if (counter == -1) break;
                if (type.equals("hits")) {
                    values[counter] = ((Long)entry[1]).doubleValue();
                } else if (type.equals("exectime")) {
                    values[counter] = (Double)entry[1];
                } else if (type.equals("error")) {
                    values[counter] = ((Long)entry[1]).doubleValue();
                }
                log.trace((Object)("Inserting the value " + values[counter] + " for date: " + date + " on position: " + counter));
                --counter;
                currentDate = DateHelper.subtractDay(currentDate);
            }
            String str = new String();
            for (counter = 0; counter < values.length; ++counter) {
                str = str + values[counter] + ", ";
            }
            log.debug((Object)("The query on " + type + " with service " + service + " is returning values: " + str));
            session.close();
            return values;
        }
        catch (Exception e) {
            log.error((Object)("Error while querying for the " + type + " with service " + service + " : " + e.getMessage()), (Throwable)e);
            if (session.isConnected()) {
                session.close();
            }
            return null;
        }
    }

    public int getRunningJobs(String service) {
        String query = " select count(jobID) from JobInfo where (code=1 or code=2 or code=64 or code=128) and serviceName like '" + service + "%' ";
        Session session = this.sessionFactory.openSession();
        Long ret = (Long)session.createQuery(query).uniqueResult();
        session.close();
        log.debug((Object)("getRunningJobs for service: " + service + " returning:" + ret));
        return ret.intValue();
    }

    public boolean isVersion(String versionNumber) {
        String[] numbers = versionNumber.split(".");
        NumberFormat numberFormat = NumberFormat.getInstance();
        for (int i = 0; i < numbers.length; ++i) {
            try {
                numberFormat.parse(numbers[i]);
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private String getQueryExectime() {
        String query = null;
        String queryTail = " from job_info jobInfo  where jobInfo.service_name like :service  and jobInfo.start_time_date >= :startDate  and jobInfo.start_time_date <= :endDate  and jobInfo.code=8  group by jobInfo.start_time_date  order by jobInfo.start_time_date desc";
        String dialect = this.getDialect();
        log.debug((Object)("The dialect in use is: " + dialect));
        if (dialect.equals("org.hibernate.dialect.HSQLDialect")) {
            query = "select jobInfo.start_time_date as date,  avg( datediff('ss', jobInfo.start_time_date, jobInfo.last_update_date) +  datediff('ss', jobInfo.start_time_time, jobInfo.last_update_time) ) as average " + queryTail;
        } else if (dialect.equals("org.hibernate.dialect.PostgreSQLDialect")) {
            query = "select jobInfo.start_time_date as date,  avg( ( last_update_date - start_time_date ) * 86400 +  extract(epoch from ( last_update_time - start_time_time))) as average " + queryTail;
        } else if (dialect.equals("org.hibernate.dialect.MySQLDialect")) {
            query = "select jobInfo.start_time_date as date,  avg( ( last_update_date - start_time_date ) * 86400 +  ( time_to_sec(last_update_time) - time_to_sec(start_time_time) )) as average " + queryTail;
        } else if (dialect.equals("org.hibernate.dialect.DB2Dialect")) {
            query = "select jobInfo.start_time_date as date,  avg( ( last_update_date - start_time_date ) * 86400 +  ( midnight_seconds(last_update_time) - midnight_seconds(start_time_time) )) as average " + queryTail;
        }
        return query;
    }
}

