/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.dashboard.util;

import edu.sdsc.nbcr.opal.dashboard.persistence.DBManager;
import edu.sdsc.nbcr.opal.dashboard.util.DateHelper;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class PackageTest
extends TestCase {
    private static Logger logger = Logger.getLogger((String)PackageTest.class.getName());

    public static void main(String[] args) {
        TestRunner.run((Test)PackageTest.suite());
        System.exit(0);
    }

    public PackageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PackageTest.class);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testArgValidator() {
        DBManager dbManager = new DBManager();
        PackageTest.assertTrue((String)"We could not get connection to the database.", (boolean)dbManager.isConnected());
        String[] servicesList = dbManager.getServicesList();
        PackageTest.assertNotNull((String)"The list of services should not be null", (Object)servicesList);
        String startDateStr = "01/01/2009";
        String endDateStr = "02/10/2009";
        int numDays = 41;
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = DateHelper.parseDate(startDateStr);
            endDate = DateHelper.parseDate(endDateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackageTest.fail((String)"Impossible to parse the date! That's bad...");
        }
        PackageTest.assertNotNull((String)"Impossible to parse the date! It returned null...", (Object)startDate);
        PackageTest.assertNotNull((String)"Impossible to parse the date! It returned null...", (Object)endDate);
        double[] resultHolder = null;
        String[] queryTypes = new String[]{"hits", "exectime", "error"};
        for (String serviceName : servicesList) {
            for (String queryType : queryTypes) {
                resultHolder = dbManager.getResultsTimeseries(startDate, endDate, serviceName, queryType);
                PackageTest.assertNotNull((String)("The result for " + queryType + " with start date " + startDateStr + " and endDate " + endDateStr + " returned null!"), (Object)resultHolder);
                PackageTest.assertTrue((String)("The query " + queryType + " with start date " + startDateStr + " and endDate " + endDateStr + " returned a wrong number of results\nExpected " + numDays + " but returned " + resultHolder.length), (resultHolder.length == numDays ? 1 : 0) != 0);
            }
        }
        startDateStr = "03/01/2009";
        endDateStr = "02/10/2009";
        try {
            startDate = DateHelper.parseDate(startDateStr);
            endDate = DateHelper.parseDate(endDateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            PackageTest.fail((String)"Impossible to parse the date! That's bad...");
        }
        PackageTest.assertNotNull((String)"Impossible to parse the date! It returned null...", (Object)startDate);
        PackageTest.assertNotNull((String)"Impossible to parse the date! It returned null...", (Object)endDate);
        for (String serviceName : servicesList) {
            for (String queryType : queryTypes) {
                resultHolder = dbManager.getResultsTimeseries(startDate, endDate, serviceName, queryType);
                PackageTest.assertNull((String)("The result for " + queryType + " with start date " + startDateStr + " and endDate " + endDateStr + " did not return null!"), (Object)resultHolder);
            }
        }
    }
}

