/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.gui.common;

import edu.sdsc.nbcr.opal.AppConfigInputType;
import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.AppMetadataType;
import edu.sdsc.nbcr.opal.AppServiceLocator;
import edu.sdsc.nbcr.opal.AppServicePortType;
import edu.sdsc.nbcr.opal.FaultType;
import edu.sdsc.nbcr.opal.FlagsType;
import edu.sdsc.nbcr.opal.GroupsArrayType;
import edu.sdsc.nbcr.opal.GroupsType;
import edu.sdsc.nbcr.opal.ParamsArrayType;
import edu.sdsc.nbcr.opal.ParamsType;
import edu.sdsc.nbcr.opal.gui.common.AppMetadata;
import edu.sdsc.nbcr.opal.gui.common.ArgFlag;
import edu.sdsc.nbcr.opal.gui.common.ArgParam;
import edu.sdsc.nbcr.opal.gui.common.Group;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppMetadataParser {
    private static Log log = LogFactory.getLog((String)"edu.sdsc.nbcr.opal");

    public static AppMetadata parseAppMetadata(String serviceURL) {
        AppMetadata app = new AppMetadata();
        AppServiceLocator asl = new AppServiceLocator();
        log.debug((Object)"PARSER: Starting the parsing process...");
        try {
            String serviceName;
            AppServicePortType appServicePort = asl.getAppServicePort(new URL(serviceURL));
            AppConfigType act = appServicePort.getAppConfig(new AppConfigInputType());
            AppMetadataType amt = act.getMetadata();
            app.setUsage(amt.getUsage());
            app.setInfo(amt.getInfo());
            app.setURL(serviceURL);
            if (act.isParallel()) {
                app.setParallel(true);
            }
            if ((serviceName = amt.getAppName()) == null) {
                serviceName = serviceURL.substring(serviceURL.lastIndexOf("/") + 1, serviceURL.length());
            }
            app.setServiceName(serviceName);
            if (amt.getTypes() != null) {
                if (amt.getTypes().getFlags() != null && amt.getTypes().getFlags().getFlag() != null) {
                    FlagsType[] flagsType = amt.getTypes().getFlags().getFlag();
                    ArgFlag[] flags = new ArgFlag[flagsType.length];
                    for (int i = 0; i < flagsType.length; ++i) {
                        flags[i] = AppMetadataParser.parseFlag(flagsType[i]);
                    }
                    app.setArgFlags(flags);
                } else {
                    log.debug((Object)"PARSER: there are no flag in the parsed config file");
                    app.setArgFlags(null);
                }
                ParamsType[] paramsType = null;
                ArrayList<ArgParam> args = new ArrayList<ArgParam>();
                ParamsArrayType taggedArrayType = amt.getTypes().getTaggedParams();
                if (taggedArrayType != null && taggedArrayType.getParam() != null) {
                    app.setSeparator(taggedArrayType.getSeparator());
                    paramsType = taggedArrayType.getParam();
                    for (int i = 0; i < paramsType.length; ++i) {
                        args.add(AppMetadataParser.parseParam(paramsType[i], -1));
                    }
                } else {
                    log.debug((Object)"PARSER: There are not tagged parameters in the parsed file");
                }
                ParamsArrayType untaggedArrayType = amt.getTypes().getUntaggedParams();
                if (untaggedArrayType != null && untaggedArrayType.getParam() != null) {
                    paramsType = untaggedArrayType.getParam();
                    for (int i = 0; i < paramsType.length; ++i) {
                        args.add(AppMetadataParser.parseParam(paramsType[i], i));
                    }
                } else {
                    log.debug((Object)"PARSER: there are not untagged paramters in the parsed file");
                }
                if (taggedArrayType != null || untaggedArrayType != null) {
                    app.setArgParams(args.toArray(new ArgParam[args.size()]));
                }
                GroupsArrayType groupsArrayType = amt.getTypes().getGroups();
                GroupsType[] groupsType = null;
                ArrayList<Group> groups = new ArrayList<Group>();
                if (groupsArrayType != null && groupsArrayType.getGroup() != null) {
                    log.debug((Object)"PARSER: parsing groups");
                    groupsType = groupsArrayType.getGroup();
                    for (int i = 0; i < groupsType.length; ++i) {
                        groups.add(AppMetadataParser.parseGroup(groupsType[i], app));
                    }
                } else {
                    log.debug((Object)"PARSER: there are no group in the parsed config file setting up the default one");
                }
                if (!AppMetadataParser.setDefaultGroup(groups, app)) {
                    log.error((Object)"An error occurred while setting the default group.");
                }
                app.setGroups(groups.toArray(new Group[groups.size()]));
            } else {
                log.debug((Object)"PARSER: no types found in the config file");
            }
            log.debug((Object)("PARSER: ---  Parsed sucesfully the configuration file    --\n" + (Object)((Object)app) + "PARSER:         ------------        "));
        }
        catch (FaultType e) {
            log.error((Object)("PARSER: Unable to get the appMetadata from the Opal server. Error: " + e.getMessage1()));
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            log.error((Object)("PARSER: Unable to get the appMetadata from the Opal server. Error: " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
        return app;
    }

    private static ArgFlag parseFlag(FlagsType flagType) {
        ArgFlag flag = new ArgFlag();
        flag.setId(flagType.getId().toString());
        flag.setTag(flagType.getTag());
        flag.setTextDesc(flagType.getTextDesc());
        Boolean defaultValue = flagType.get_default();
        if (defaultValue != null) {
            flag.setSelected(defaultValue);
        }
        return flag;
    }

    private static ArgParam parseParam(ParamsType paramType, int position) {
        log.debug((Object)("parsing the paramType: " + paramType.getTag()));
        ArgParam arg = new ArgParam();
        arg.setId(paramType.getId().toString());
        arg.setTag(paramType.getTag());
        arg.setTextDesc(paramType.getTextDesc());
        String defaultValue = paramType.get_default();
        if (defaultValue != null && defaultValue.length() != 0) {
            arg.setSelectedValue(defaultValue);
        }
        if (paramType.getParamType() != null) {
            arg.setType(paramType.getParamType().getValue());
        }
        if (paramType.getIoType() != null) {
            arg.setIoType(paramType.getIoType().getValue());
        }
        arg.setSemanticType(paramType.getSemanticType());
        arg.setValues(paramType.getValue());
        if (paramType.getRequired() != null) {
            arg.setRequired(paramType.getRequired());
        }
        arg.setPosition(position);
        return arg;
    }

    private static Group parseGroup(GroupsType groupType, AppMetadata app) {
        boolean required = false;
        Group group = new Group();
        group.setName(groupType.getName());
        if (groupType.getExclusive() != null) {
            group.setExclusive(groupType.getExclusive());
        }
        if (groupType.getRequired() != null) {
            required = groupType.getRequired();
            group.setRequired(required);
        }
        group.setTextDesc(groupType.getTextDesc());
        group.setSemanticType(groupType.getSemanticType());
        ArrayList<ArgParam> params = new ArrayList<ArgParam>();
        ArrayList<ArgFlag> flags = new ArrayList<ArgFlag>();
        StringTokenizer tokenizer = new StringTokenizer(groupType.getElements().toString());
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (app.getArgFlagId(id) != null) {
                flags.add(app.getArgFlagId(id));
                continue;
            }
            if (app.getArgParamId(id) != null) {
                if (required) {
                    app.getArgParamId(id).setRequired(required);
                }
                params.add(app.getArgParamId(id));
                continue;
            }
            log.error((Object)("The parameters idref " + id + " of the group " + group.getName() + " is available nor in the flags neither in the params!!"));
        }
        if (!flags.isEmpty()) {
            group.setArgFlags(flags.toArray(new ArgFlag[flags.size()]));
        }
        if (!params.isEmpty()) {
            group.setArgParams(params.toArray(new ArgParam[params.size()]));
        }
        return group;
    }

    private static boolean setDefaultGroup(ArrayList groups, AppMetadata app) {
        int i;
        ArgParam[] ungroupedParams = AppMetadataParser.getUngroupedParams(groups, app.getArgParams());
        ArgFlag[] ungroupedFlags = AppMetadataParser.getUngroupedFlags(groups, app.getArgFlags());
        if (ungroupedParams.length == 0 && ungroupedFlags.length == 0) {
            log.debug((Object)"There are no parameters or flags ungrouped...");
            return true;
        }
        String info = "PARSER: the ungropped paramters are: ";
        for (i = 0; i < ungroupedParams.length; ++i) {
            info = info + ungroupedParams[i].getId() + " ";
        }
        info = info + "\nPARSER: the ungroupped flags are: ";
        for (i = 0; i < ungroupedFlags.length; ++i) {
            info = info + ungroupedFlags[i].getId() + " ";
        }
        log.debug((Object)info);
        Group defaultGroup = new Group();
        defaultGroup.setName("Default Group");
        defaultGroup.setTextDesc("Ungrouped input fields...");
        defaultGroup.setArgFlags(ungroupedFlags);
        defaultGroup.setArgParams(ungroupedParams);
        groups.add(defaultGroup);
        return true;
    }

    private static ArgParam[] getUngroupedParams(ArrayList groups, ArgParam[] params) {
        if (params == null) {
            return new ArgParam[0];
        }
        ArrayList<ArgParam> paramList = new ArrayList<ArgParam>(Arrays.asList(params));
        for (int i = 0; i < groups.size(); ++i) {
            ArgParam[] usedParams = ((Group)groups.get(i)).getArgParams();
            if (usedParams == null) continue;
            for (int t = 0; t < usedParams.length; ++t) {
                paramList.remove((Object)usedParams[t]);
            }
        }
        return paramList.toArray(new ArgParam[paramList.size()]);
    }

    private static ArgFlag[] getUngroupedFlags(ArrayList groups, ArgFlag[] flags) {
        if (flags == null) {
            return new ArgFlag[0];
        }
        ArrayList<ArgFlag> flagsList = new ArrayList<ArgFlag>(Arrays.asList(flags));
        for (int i = 0; i < groups.size(); ++i) {
            ArgFlag[] usedFlags = ((Group)groups.get(i)).getArgFlags();
            if (usedFlags == null) continue;
            for (int t = 0; t < usedFlags.length; ++t) {
                flagsList.remove((Object)usedFlags[t]);
            }
        }
        return flagsList.toArray(new ArgFlag[flagsList.size()]);
    }

    private static AppMetadata createStaticAppMetadata() {
        AppMetadata app = new AppMetadata();
        String[] str = new String[]{"man page"};
        app.setInfo(str);
        app.setUsage("python pdb2pqr.py [options] --ff={forcefield} {path} {output-path}");
        app.setServiceName("PDB2PQR");
        app.setURL("http://localhost:8080/axis/services/PDB2PQR");
        ArgFlag[] flags = new ArgFlag[]{new ArgFlag("nodebump", "--nodebump", "Do not perform the debumping operation"), new ArgFlag("noopt", "--noopt", "Do not perform hydrogen bonding network optimization"), new ArgFlag("clean", "--clean", "Do no optimization, atom addition, or parameter assignment"), new ArgFlag("chain", "--chain", "Keep the chain ID in the output PQR file"), new ArgFlag("assign-only", "--assign-only", "Only assign charges and radii - do not add atoms, debump, or optimize")};
        app.setArgFlags(flags);
        String[] values = new String[]{"AMBER", "CHARMM", "PARSE", "TYL06"};
        ArgParam[] args = new ArgParam[]{new ArgParam("path", null, "FILE", "INPUT", true, null, null, "Input PDB file *"), new ArgParam("forcefield", "--ff", "STRING", "INPUT", true, values, null, "The forcefield to use -- currently AMBER, CHARMM, PARSE, and TYL06 are supported *"), new ArgParam("output-path", null, "STRING", "OUTPUT", false, null, null, "The desired output name of the PQR file to be generated"), new ArgParam("ffout", "--ffout", "STRING", null, false, null, null, "Instead of using the standard canonical naming scheme, use the names from the given forcefield"), new ArgParam("with-ph", "--with-ph", "STRING", null, false, null, null, "Use PROPKA to calculate pKas and apply them to the molecule given the pH value"), new ArgParam("ligand", "--ligand", "FILE", "OUTPUT", false, null, null, "Use the PDB2PKA package to generate parameters for the specific ligand in MOL2 format")};
        app.setArgParams(args);
        app.setSeparator("=");
        return app;
    }
}

