/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.JobInfo;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.Session;
import org.ggf.drmaa.SessionFactory;
import org.ggf.drmaa.UnsupportedAttributeException;

public class DRMAAJobManager
implements OpalJobManager {
    private static Logger logger = Logger.getLogger((String)DRMAAJobManager.class.getName());
    private Properties props;
    private AppConfigType config;
    private StatusOutputType status;
    private String handle;
    private boolean started = false;
    private volatile boolean done = false;
    private static Session session = null;
    private JobInfo jobInfo;

    @Override
    public void initialize(Properties props, AppConfigType config, String handle) throws JobManagerException {
        logger.info((Object)"called");
        this.props = props;
        this.config = config;
        this.handle = handle;
        this.status = new StatusOutputType();
    }

    @Override
    public void destroyJobManager() throws JobManagerException {
        logger.info((Object)"called");
        throw new JobManagerException("destroyJobManager() method not implemented");
    }

    @Override
    public String launchJob(String argList, Integer numProcs, String workingDir) throws JobManagerException {
        logger.info((Object)"called");
        if (this.config == null) {
            String msg = "Can't find application configuration - Plugin not initialized correctly";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String args = this.config.getDefaultArgs();
        if (args == null) {
            args = argList;
        } else {
            String userArgs = argList;
            if (userArgs != null) {
                args = args + " " + userArgs;
            }
        }
        if (args != null) {
            args = args.trim();
        }
        logger.debug((Object)("Argument list: " + args));
        String systemProcsString = this.props.getProperty("num.procs");
        int systemProcs = 0;
        if (systemProcsString != null) {
            systemProcs = Integer.parseInt(systemProcsString);
        }
        String cmd = null;
        String[] argsArray = null;
        if (this.config.isParallel()) {
            if (numProcs == null) {
                String msg = "Number of processes unspecified for parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            if (numProcs > systemProcs) {
                String msg = "Processors required - " + numProcs + ", available - " + systemProcs;
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            String mpiRun = this.props.getProperty("mpi.run");
            if (mpiRun == null) {
                String msg = "Can't find property mpi.run for running parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            cmd = "/bin/sh";
            String newArgs = mpiRun + " -machinefile $TMPDIR/machines" + " -np " + numProcs + " " + this.config.getBinaryLocation();
            args = args != null && !args.equals("") ? newArgs + " " + args : newArgs;
            logger.debug((Object)("CMD: " + args));
            argsArray = new String[]{"-c", args};
        } else {
            cmd = this.config.getBinaryLocation();
            if (args == null) {
                args = "";
            }
            logger.debug((Object)("CMD: " + cmd + " " + args));
            argsArray = !args.equals("") ? args.split("[\\s]+") : new String[]{};
        }
        String drmaaPE = null;
        if (this.config.isParallel()) {
            String appDrmaaPE = this.config.getDrmaaPE();
            if (appDrmaaPE != null && !appDrmaaPE.equals("")) {
                drmaaPE = appDrmaaPE;
                logger.debug((Object)"Drmaa parallel environment defined at app level");
            } else {
                drmaaPE = this.props.getProperty("drmaa.pe");
                logger.debug((Object)"Drmaa parallel environment defined at server level");
            }
            logger.debug((Object)("Using drmaa parallel environment " + drmaaPE));
            if (drmaaPE == null) {
                String msg = "Can't find property drmaa.pe for running parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
        }
        String drmaaQueue = null;
        String appDrmaaQueue = this.config.getDrmaaQueue();
        if (appDrmaaQueue != null && !appDrmaaQueue.equals("")) {
            drmaaQueue = appDrmaaQueue;
            logger.debug((Object)"Drmaa parallel queue at app level");
        } else {
            drmaaQueue = this.props.getProperty("drmaa.queue");
            logger.debug((Object)"Drmaa parallel queue at server level");
        }
        logger.debug((Object)("Using drmaa queue " + drmaaQueue));
        long hardLimit = 0L;
        if (this.props.getProperty("opal.hard_limit") != null) {
            hardLimit = Long.parseLong(this.props.getProperty("opal.hard_limit"));
            logger.info((Object)("All jobs have a hard limit of " + hardLimit + " seconds"));
        }
        try {
            logger.debug((Object)("Working directory: " + workingDir));
            JobTemplate jt = session.createJobTemplate();
            String nativeSpec = "";
            if (drmaaQueue != null && !drmaaQueue.equals("")) {
                nativeSpec = nativeSpec + "-q " + drmaaQueue + " ";
            }
            if (this.config.isParallel()) {
                nativeSpec = nativeSpec + "-pe " + drmaaPE + " " + numProcs;
            }
            jt.setNativeSpecification(nativeSpec);
            jt.setRemoteCommand(cmd);
            jt.setArgs(Arrays.asList(argsArray));
            jt.setWorkingDirectory(workingDir);
            jt.setErrorPath(":" + workingDir + "/stderr.txt");
            jt.setOutputPath(":" + workingDir + "/stdout.txt");
            if (hardLimit != 0L) {
                try {
                    jt.setHardRunDurationLimit(hardLimit);
                }
                catch (UnsupportedAttributeException e) {
                    String msg = "Can't set hard limit - " + e.getMessage();
                    logger.error((Object)msg);
                }
            }
            this.handle = session.runJob(jt);
            logger.info((Object)("DRMAA job has been submitted with id " + this.handle));
            session.deleteJobTemplate(jt);
        }
        catch (Exception e) {
            String msg = "Error while running executable via DRMAA - " + e.getMessage();
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.started = true;
        return this.handle;
    }

    @Override
    public StatusOutputType waitForActivation() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            while (session.getJobProgramStatus(this.handle) == 16 || session.getJobProgramStatus(this.handle) == 17 || session.getJobProgramStatus(this.handle) == 18 || session.getJobProgramStatus(this.handle) == 19) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    logger.error((Object)ie.getMessage());
                }
            }
        }
        catch (DrmaaException de) {
            String msg = "Can't get status for DRMAA job: " + this.handle;
            logger.error((Object)msg, (Throwable)de);
            throw new JobManagerException(msg + " - " + de.getMessage());
        }
        this.status.setCode(2);
        this.status.setMessage("Execution in progress");
        return this.status;
    }

    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        int exitValue;
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            this.jobInfo = session.wait(this.handle, -1L);
        }
        catch (DrmaaException de) {
            String msg = "Exception while waiting for process to finish";
            logger.error((Object)msg, (Throwable)de);
            throw new JobManagerException(msg + " - " + de.getMessage());
        }
        try {
            exitValue = this.jobInfo.getExitStatus();
        }
        catch (DrmaaException e) {
            logger.error((Object)"Can't get exit value from DRMAA - setting it to 100");
            exitValue = 100;
        }
        if (exitValue == 0) {
            this.status.setCode(8);
            this.status.setMessage("Execution complete - check outputs to verify successful execution");
        } else {
            this.status.setCode(4);
            this.status.setMessage("Execution failed - process exited with value " + exitValue);
        }
        return this.status;
    }

    @Override
    public StatusOutputType destroyJob() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't destroy a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            session.control(this.handle, 4);
        }
        catch (DrmaaException de) {
            String msg = "Exception while trying to destroy process";
            logger.error((Object)msg, (Throwable)de);
            throw new JobManagerException(msg + " - " + de.getMessage());
        }
        this.status.setCode(4);
        this.status.setMessage("Process destroyed on user request");
        return this.status;
    }

    static {
        SessionFactory factory = SessionFactory.getFactory();
        session = factory.getSession();
        try {
            session.init(null);
        }
        catch (DrmaaException de) {
            logger.fatal((Object)("Can't initialize DRMAA session: " + de.getMessage()));
        }
    }
}

