/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.globus.gram.Gram;
import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.ietf.jgss.GSSCredential;

public class GlobusJobManager
implements OpalJobManager,
GramJobListener {
    private static Logger logger = Logger.getLogger((String)GlobusJobManager.class.getName());
    protected Properties props;
    protected AppConfigType config;
    protected StatusOutputType status;
    protected String handle;
    protected boolean started = false;
    protected boolean active = false;
    protected boolean destroyed = false;
    protected GramJob job;

    @Override
    public void initialize(Properties props, AppConfigType config, String handle) throws JobManagerException {
        logger.info((Object)"called");
        this.props = props;
        this.config = config;
        this.handle = handle;
        this.status = new StatusOutputType();
    }

    @Override
    public void destroyJobManager() throws JobManagerException {
        logger.info((Object)"called");
        throw new JobManagerException("destroyJobManager() method not implemented");
    }

    @Override
    public String launchJob(String argList, Integer numProcs, String workingDir) throws JobManagerException {
        logger.info((Object)"called");
        if (this.config == null) {
            String msg = "Can't find application configuration - Plugin not initialized correctly";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String args = this.config.getDefaultArgs();
        if (args == null) {
            args = argList;
        } else {
            String userArgs = argList;
            if (userArgs != null) {
                args = args + " " + userArgs;
            }
        }
        if (args != null) {
            args = args.trim();
        }
        logger.debug((Object)("Argument list: " + args));
        String systemProcsString = this.props.getProperty("num.procs");
        int systemProcs = 0;
        if (systemProcsString != null) {
            systemProcs = Integer.parseInt(systemProcsString);
        }
        String rsl = null;
        if (this.config.isParallel()) {
            if (numProcs == null) {
                String msg = "Number of processes unspecified for parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            if (numProcs > systemProcs) {
                String msg = "Processors required - " + numProcs + ", available - " + systemProcs;
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            rsl = "&(directory=" + workingDir + ")" + "(executable=" + this.config.getBinaryLocation() + ")" + "(count=" + numProcs + ")" + "(jobtype=mpi)" + "(stdout=stdout.txt)" + "(stderr=stderr.txt)";
        } else {
            rsl = "&(directory=" + workingDir + ")" + "(executable=" + this.config.getBinaryLocation() + ")" + "(stdout=stdout.txt)" + "(stderr=stderr.txt)";
        }
        long hardLimit = 0L;
        if (this.props.getProperty("opal.hard_limit") != null) {
            hardLimit = Long.parseLong(this.props.getProperty("opal.hard_limit")) / 60L;
            logger.info((Object)("All jobs have a hard limit of " + hardLimit + " minutes"));
            rsl = rsl + "(maxWallTime=" + hardLimit + ")";
        }
        if (args != null && !args.equals("")) {
            args = "\"" + args + "\"";
            args = args.replaceAll("[\\s]+", "\" \"");
            rsl = rsl + "(arguments=" + args + ")";
        }
        logger.debug((Object)("RSL: " + rsl));
        String serviceCertPath = this.props.getProperty("globus.service_cert");
        if (serviceCertPath == null) {
            String msg = "Can't find property: globus.service_cert";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String serviceKeyPath = this.props.getProperty("globus.service_privkey");
        if (serviceKeyPath == null) {
            String msg = "Can't find property: globus.service_privkey";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String gatekeeperContact = this.props.getProperty("globus.gatekeeper");
        if (this.config.getGlobusGatekeeper() != null) {
            gatekeeperContact = this.config.getGlobusGatekeeper().toString();
        }
        if (gatekeeperContact == null) {
            String msg = "Can't find property: globus.gatekeeper";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            this.job = new GramJob(rsl);
            GlobusCredential globusCred = new GlobusCredential(serviceCertPath, serviceKeyPath);
            GlobusGSSCredentialImpl gssCred = new GlobusGSSCredentialImpl(globusCred, 0);
            this.job.setCredentials((GSSCredential)gssCred);
            this.job.request(gatekeeperContact);
            this.job.addListener((GramJobListener)this);
            this.handle = this.job.getIDAsString();
        }
        catch (Exception e) {
            String msg = "Error while running executable via Globus - " + e.getMessage();
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.started = true;
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusOutputType waitForActivation() throws JobManagerException {
        logger.info((Object)"called");
        while (!this.active) {
            try {
                GramJob gramJob = this.job;
                synchronized (gramJob) {
                    this.job.wait();
                }
            }
            catch (InterruptedException ie) {
                logger.error((Object)ie.getMessage());
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            while (this.status.getCode() != 4 && this.status.getCode() != 8) {
                GramJob msg = this.job;
                synchronized (msg) {
                    this.job.wait();
                }
            }
            return this.status;
        }
        catch (Exception e) {
            String msg = "Exception while waiting for Globus process to finish";
            logger.error((Object)msg, (Throwable)e);
            throw new JobManagerException(msg + " - " + e.getMessage());
        }
    }

    @Override
    public StatusOutputType destroyJob() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't destroy a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            this.job.cancel();
            this.destroyed = true;
        }
        catch (Exception e) {
            String msg = "Exception while trying to destroy Globus process";
            logger.error((Object)msg, (Throwable)e);
            throw new JobManagerException(msg + " - " + e.getMessage());
        }
        this.status.setCode(4);
        this.status.setMessage("Process destroyed on user request");
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusChanged(GramJob job) {
        GramJob gramJob;
        logger.info((Object)("called for job: " + this.handle));
        int code = job.getStatus();
        String message = code == 8 ? GramJob.getStatusAsString((int)code) + " - check outputs to verify successful execution" : (code == 4 ? GramJob.getStatusAsString((int)code) + ", Error code - " + job.getError() : GramJob.getStatusAsString((int)code));
        logger.info((Object)("Job status: " + message));
        this.status.setCode(code);
        if (!this.destroyed) {
            this.status.setMessage(message);
        }
        if (!(this.active || code != 2 && code != 8 && code != 4)) {
            this.active = true;
            gramJob = job;
            synchronized (gramJob) {
                job.notifyAll();
            }
        }
        if (code == 8 || code == 4) {
            job.removeListener((GramJobListener)this);
            Gram.deactivateCallbackHandler((GSSCredential)job.getCredentials());
        }
        if (code == 4 || code == 8) {
            logger.info((Object)("Job " + this.handle + " finished with status - " + message));
            gramJob = job;
            synchronized (gramJob) {
                job.notifyAll();
            }
        }
    }
}

