/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.util;

import edu.sdsc.nbcr.common.TypeDeserializer;
import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.gui.common.GetServiceListHelper;
import edu.sdsc.nbcr.opal.gui.common.OPALService;
import edu.sdsc.nbcr.opal.state.HibernateUtil;
import edu.sdsc.nbcr.opal.state.ServiceStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.axis.AxisFault;
import org.apache.axis.client.AdminClient;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpalDeployService
extends HttpServlet {
    protected static Log logger = LogFactory.getLog((String)OpalDeployService.class.getName());
    protected static Deployer deplo = null;
    protected static String wsddDirectory = null;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.info((Object)"Loading OpalDeployService (init method).");
        Properties props = new Properties();
        String propsFileName = "opal.properties";
        String deployPath = "";
        try {
            props.load(OpalDeployService.class.getClassLoader().getResourceAsStream(propsFileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Unable to load opal.properties: " + e.getMessage()));
            return;
        }
        String axisServicesUrl = this.getServletContext().getInitParameter("OPAL_URL");
        if (axisServicesUrl == null) {
            logger.warn((Object)"OPAL_URL not found in web.xml. Using default.");
            axisServicesUrl = "http://localhost:8080/opal2/services";
        }
        if (props.getProperty("opal.deploy.path") != null) {
            deployPath = props.getProperty("opal.deploy.path");
        }
        if (deployPath.length() == 0) {
            logger.error((Object)"opal.deploy.path is not present! Fix your opal.properties.");
            return;
        }
        wsddDirectory = config.getServletContext().getRealPath("/WEB-INF/wsdd/");
        File deployPathFile = new File(deployPath);
        if (!deployPathFile.exists()) {
            deployPathFile.mkdir();
        }
        deplo = new Deployer();
        deplo.setValues(axisServicesUrl, deployPathFile);
        deplo.setName("OpalDeployer");
        deplo.start();
    }

    public void destroy() {
        deplo.stopThread();
    }

    public class DeployListener
    implements FileAlterationListener {
        public void onStart(FileAlterationObserver observer) {
        }

        public void onStop(FileAlterationObserver observer) {
        }

        public void onDirectoryCreate(File directory) {
        }

        public void onDirectoryChange(File directory) {
        }

        public void onDirectoryDelete(File directory) {
        }

        public void onFileCreate(File file) {
            logger.info((Object)("Autodeploy file: " + file));
            deplo.deploy(file);
        }

        public void onFileChange(File file) {
            logger.debug((Object)("AppConfig modified (nothing will be done): " + file));
        }

        public void onFileDelete(File file) {
            logger.info((Object)("Undeploying file: " + file));
            String serviceName = FilenameUtils.getBaseName((String)file.toString());
            if (serviceName != null) {
                deplo.undeploy(serviceName);
                logger.info((Object)("Service " + serviceName + " undeployed"));
            }
        }
    }

    public class Deployer
    extends Thread {
        private String axisAdminUrl;
        private String axisServicesUrl;
        private File deployPathFile;
        private boolean run;

        public void stopThread() {
            this.run = false;
        }

        public void setValues(String axisServicesUrl, File path) {
            this.axisServicesUrl = axisServicesUrl;
            this.axisAdminUrl = axisServicesUrl.substring(0, axisServicesUrl.lastIndexOf(47));
            this.axisAdminUrl = this.axisAdminUrl + "/servlet/AxisServlet";
            this.deployPathFile = path;
        }

        @Override
        public void run() {
            File[] deployFileList;
            logger.info((Object)"starting thread OpalDeployer");
            while (true) {
                try {
                    URL url = new URL(this.axisAdminUrl);
                    HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                    urlConn.setConnectTimeout(1000);
                    Deployer.sleep(2000L);
                    urlConn.connect();
                }
                catch (IOException e) {
                    logger.info((Object)"Axis admin is not ready yet");
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("problem while waiting for server startup: " + e));
                    return;
                }
                break;
            }
            logger.info((Object)("initDeployServlet: axis URL: " + this.axisAdminUrl));
            logger.info((Object)("initDeployServlet: deploy path: " + this.deployPathFile.getAbsolutePath()));
            GetServiceListHelper helper = new GetServiceListHelper();
            helper.setBasePrivateURL(this.axisServicesUrl);
            helper.setBasePublicURL(this.axisServicesUrl);
            OPALService[] servicesList = helper.getOpalServiceList();
            if (servicesList == null) {
                logger.error((Object)"Unable to parse the service list from the server");
                return;
            }
            for (OPALService service : servicesList) {
                logger.info((Object)("undeploying service: " + service.getServiceName()));
                this.undeploy(service.getServiceName());
            }
            for (File configFile : deployFileList = this.deployPathFile.listFiles()) {
                logger.info((Object)("deploying service: " + configFile));
                try {
                    this.deploy(configFile);
                }
                catch (Exception e) {
                    logger.error((Object)("configFile does not exist: " + e));
                }
            }
            this.run = true;
            FileAlterationObserver observer = new FileAlterationObserver(this.deployPathFile);
            observer.addListener((FileAlterationListener)new DeployListener());
            try {
                observer.initialize();
                while (this.run) {
                    observer.checkAndNotify();
                    Deployer.sleep(1000L);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Deployer failed to monitor the deployment directory: " + e));
            }
        }

        public void deploy(File appConfigFile) {
            logger.info((Object)("deploy with appconfig: " + appConfigFile));
            String wsddTemplate = wsddDirectory + "/opal_deploy.wsdd";
            String templateData = null;
            try {
                File f = new File(wsddTemplate);
                byte[] data = new byte[(int)f.length()];
                FileInputStream fIn = new FileInputStream(f);
                fIn.read(data);
                fIn.close();
                templateData = new String(data);
            }
            catch (Exception e) {
                logger.error((Object)("unable to read wsdd template file: " + e));
                return;
            }
            if (!appConfigFile.exists()) {
                logger.error((Object)("Application configuration file " + appConfigFile + " does not exist"));
            }
            AppConfigType config = null;
            try {
                config = (AppConfigType)TypeDeserializer.getValue(appConfigFile.toString(), new AppConfigType());
            }
            catch (Exception e) {
                logger.error((Object)e);
                logger.error((Object)("appConfiguration is invalid: " + appConfigFile));
                return;
            }
            String serviceName = FilenameUtils.getBaseName((String)appConfigFile.toString());
            logger.info((Object)("Service name used for deployment: " + serviceName));
            String finalData = templateData.replaceAll("@SERVICE_NAME@", serviceName);
            finalData = finalData.replaceAll("@CONFIG_LOCATION@", appConfigFile.toString());
            logger.info((Object)("Using location of config file: " + appConfigFile));
            try {
                File wsddFinal = File.createTempFile("wsdd_" + serviceName, ".xml");
                FileOutputStream fOut = new FileOutputStream(wsddFinal);
                fOut.write(finalData.getBytes());
                fOut.close();
                if (this.runAxisAdmin(wsddFinal.getCanonicalPath())) {
                    logger.info((Object)"Updating service status in database to ACTIVE");
                    ServiceStatus serviceStatus = new ServiceStatus();
                    serviceStatus.setServiceName(serviceName);
                    serviceStatus.setStatus("ACTIVE");
                    HibernateUtil.saveServiceStatus(serviceStatus);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Deploy: failing while writing wsdd file " + e));
            }
        }

        public void undeploy(String serviceName) {
            logger.info((Object)("Undeploy called. ServiceName set to: " + serviceName));
            String wsddTemplate = wsddDirectory + "/opal_undeploy.wsdd";
            String templateData = null;
            try {
                File f = new File(wsddTemplate);
                byte[] data = new byte[(int)f.length()];
                FileInputStream fIn = new FileInputStream(f);
                fIn.read(data);
                fIn.close();
                templateData = new String(data);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to read the wsdd undeploy: " + e));
                return;
            }
            String finalData = templateData.replaceAll("@SERVICE_NAME@", serviceName);
            try {
                File wsddFinal = File.createTempFile("wsdd_" + serviceName, ".xml");
                FileOutputStream fOut = new FileOutputStream(wsddFinal);
                fOut.write(finalData.getBytes());
                fOut.close();
                if (this.runAxisAdmin(wsddFinal.getCanonicalPath())) {
                    logger.info((Object)"Updating service status in database to INACTIVE");
                    ServiceStatus serviceStatus = new ServiceStatus();
                    serviceStatus.setServiceName(serviceName);
                    serviceStatus.setStatus("INACTIVE");
                    HibernateUtil.saveServiceStatus(serviceStatus);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failing while writing wsdd file " + e));
            }
        }

        boolean runAxisAdmin(String wsddFilePath) {
            logger.info((Object)("AxisAdmin: called with wsdd path:" + wsddFilePath));
            String[] args = new String[]{"-l" + this.axisAdminUrl, wsddFilePath};
            try {
                AdminClient admin = new AdminClient();
                String result = admin.process(args);
                if (result != null) {
                    logger.info((Object)StringUtils.unescapeNumericChar((String)result));
                    return true;
                }
                logger.error((Object)"AxisAdmin failed for unknown reason");
                return false;
            }
            catch (AxisFault ae) {
                logger.error((Object)("AxisAdmin fault: " + ae.dumpToString()));
                return false;
            }
            catch (Exception e) {
                logger.error((Object)("AxisAdmin exception: " + e.getMessage()));
                return false;
            }
        }
    }
}

