/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.ChecksumAlgorithm;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.FTPClient;
import org.globus.ftp.FeatureList;
import org.globus.ftp.FileRandomIO;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.HostPort;
import org.globus.ftp.HostPort6;
import org.globus.ftp.HostPortList;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.Session;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.extended.GridFTPControlChannel;
import org.globus.ftp.extended.GridFTPServerFacade;
import org.globus.ftp.vanilla.Command;
import org.globus.ftp.vanilla.Reply;
import org.globus.gsi.gssapi.auth.Authorization;
import org.ietf.jgss.GSSCredential;

public class GridFTPClient
extends FTPClient {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ftp$GridFTPClient == null ? (class$org$globus$ftp$GridFTPClient = GridFTPClient.class$("org.globus.ftp.GridFTPClient")) : class$org$globus$ftp$GridFTPClient).getName());
    protected GridFTPSession gSession = new GridFTPSession();
    protected GridFTPServerFacade gLocalServer;
    static /* synthetic */ Class class$org$globus$ftp$GridFTPClient;

    public GridFTPClient(String host, int port) throws IOException, ServerException {
        this.session = this.gSession;
        this.controlChannel = new GridFTPControlChannel(host, port);
        this.controlChannel.open();
        this.gLocalServer = new GridFTPServerFacade((GridFTPControlChannel)this.controlChannel);
        this.localServer = this.gLocalServer;
        this.gLocalServer.authorize();
    }

    public void authenticate(GSSCredential credential) throws IOException, ServerException {
        this.authenticate(credential, null);
    }

    public void authenticate(GSSCredential credential, String username) throws IOException, ServerException {
        ((GridFTPControlChannel)this.controlChannel).authenticate(credential, username);
        this.gLocalServer.setCredential(credential);
        this.gSession.authorized = true;
        this.username = username;
    }

    public Vector list(String filter, String modifier) throws ServerException, ClientException, IOException {
        if (this.gSession.parallel > 1) {
            throw new ClientException(8, "list cannot be called with parallelism");
        }
        return super.list(filter, modifier);
    }

    public Vector nlist(String path) throws ServerException, ClientException, IOException {
        if (this.gSession.parallel > 1) {
            throw new ClientException(8, "nlist cannot be called with parallelism");
        }
        return super.nlist(path);
    }

    public Vector mlsd(String filter) throws ServerException, ClientException, IOException {
        if (this.gSession.parallel > 1) {
            throw new ClientException(8, "mlsd cannot be called with parallelism");
        }
        return super.mlsd(filter);
    }

    protected void listCheck() throws ClientException {
    }

    protected void checkTransferParamsGet() throws ServerException, IOException, ClientException {
        Session localSession = this.localServer.getSession();
        this.session.matches(localSession);
        if (this.session.serverMode == -1) {
            HostPort hp = this.setLocalPassive();
            this.setActive(hp);
        }
    }

    public void setMode(int mode) throws IOException, ServerException {
        String modeStr = null;
        switch (mode) {
            case 1: {
                modeStr = "S";
                break;
            }
            case 2: {
                modeStr = "B";
                break;
            }
            case 3: {
                modeStr = "E";
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad mode: " + mode);
            }
        }
        this.actualSetMode(mode, modeStr);
    }

    public void setTCPBufferSize(int size) throws IOException, ServerException {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        try {
            boolean succeeded = false;
            String sizeString = Integer.toString(size);
            FeatureList feat = this.getFeatureList();
            if (feat.contains("SBUF")) {
                succeeded = this.tryExecutingCommand(new Command("SBUF", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingCommand(new Command("SITE BUFSIZE", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingTwoCommands(new Command("SITE RETRBUFSIZE", sizeString), new Command("SITE STORBUFSIZE", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingTwoCommands(new Command("SITE RBUFSZ", sizeString), new Command("SITE SBUFSZ", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingTwoCommands(new Command("SITE RBUFSIZ", sizeString), new Command("SITE SBUFSIZ", sizeString));
            }
            if (!succeeded) {
                throw new ServerException(1, "Server refused setting TCP buffer size with any of the known commands.");
            }
            this.gSession.TCPBufferSize = size;
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
    }

    private boolean tryExecutingTwoCommands(Command cmd1, Command cmd2) throws IOException, FTPReplyParseException, ServerException {
        boolean result = this.tryExecutingCommand(cmd1);
        if (result) {
            result = this.tryExecutingCommand(cmd2);
        }
        return result;
    }

    private boolean tryExecutingCommand(Command cmd) throws IOException, FTPReplyParseException, ServerException {
        Reply reply = this.controlChannel.exchange(cmd);
        return Reply.isPositiveCompletion(reply);
    }

    public void setLocalTCPBufferSize(int size) throws ClientException {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.gLocalServer.setTCPBufferSize(size);
    }

    public HostPortList setStripedPassive() throws IOException, ServerException {
        Command cmd = new Command("SPAS", this.controlChannel.isIPv6() ? "2" : null);
        Reply reply = null;
        try {
            reply = this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.serverMode = 3;
        if (this.controlChannel.isIPv6()) {
            this.gSession.serverAddressList = HostPortList.parseIPv6Format(reply.getMessage());
            int size = this.gSession.serverAddressList.size();
            for (int i = 0; i < size; ++i) {
                HostPort6 hp = (HostPort6)this.gSession.serverAddressList.get(i);
                if (hp.getHost() != null) continue;
                hp.setVersion("2");
                hp.setHost(this.controlChannel.getHost());
            }
        } else {
            this.gSession.serverAddressList = HostPortList.parseIPv4Format(reply.getMessage());
        }
        return this.gSession.serverAddressList;
    }

    public void setStripedActive(HostPortList hpl) throws IOException, ServerException {
        Command cmd = new Command("SPOR", hpl.toFtpCmdArgument());
        try {
            this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.serverMode = 4;
    }

    public HostPortList setLocalStripedPassive(int port, int queue) throws IOException {
        return this.gLocalServer.setStripedPassive(port, queue);
    }

    public HostPortList setLocalStripedPassive() throws IOException {
        return this.gLocalServer.setStripedPassive();
    }

    public void setLocalStripedActive() throws ClientException, IOException {
        if (this.gSession.serverAddressList == null) {
            throw new ClientException(10);
        }
        try {
            this.gLocalServer.setStripedActive(this.gSession.serverAddressList);
        }
        catch (UnknownHostException e) {
            throw new ClientException(12);
        }
    }

    public void extendedGet(String remoteFileName, long size, DataSink sink, MarkerListener mListener) throws IOException, ClientException, ServerException {
        this.extendedGet(remoteFileName, 0L, size, sink, mListener);
    }

    public void extendedGet(String remoteFileName, long offset, long size, DataSink sink, MarkerListener mListener) throws IOException, ClientException, ServerException {
        this.checkGridFTPSupport();
        this.checkTransferParamsGet();
        this.gLocalServer.store(sink);
        this.controlChannel.write(new Command("ERET", "P " + offset + " " + size + " " + remoteFileName));
        this.transferRunSingleThread(this.localServer.getControlChannel(), mListener);
    }

    public void extendedPut(String remoteFileName, DataSource source, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.extendedPut(remoteFileName, 0L, source, mListener);
    }

    public void extendedPut(String remoteFileName, long offset, DataSource source, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.checkGridFTPSupport();
        this.checkTransferParamsPut();
        this.localServer.retrieve(source);
        this.controlChannel.write(new Command("ESTO", "A " + offset + " " + remoteFileName));
        this.transferRunSingleThread(this.localServer.getControlChannel(), mListener);
    }

    public void extendedTransfer(String remoteSrcFile, GridFTPClient destination, String remoteDstFile, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.extendedTransfer(remoteSrcFile, 0L, this.getSize(remoteSrcFile), destination, remoteDstFile, 0L, mListener);
    }

    public void extendedTransfer(String remoteSrcFile, long remoteSrcFileOffset, long remoteSrcFileLength, GridFTPClient destination, String remoteDstFile, long remoteDstFileOffset, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.checkGridFTPSupport();
        destination.checkGridFTPSupport();
        this.gSession.matches(destination.gSession);
        if (this.gSession.transferMode != 3) {
            throw new ClientException(8, "Extended transfer mode is necessary");
        }
        if (this.gSession.serverMode == -1) {
            HostPort hp = destination.setPassive();
            this.setActive(hp);
        }
        Command estoCmd = new Command("ESTO", "A " + remoteDstFileOffset + " " + remoteDstFile);
        destination.controlChannel.write(estoCmd);
        Command eretCmd = new Command("ERET", "P " + remoteSrcFileOffset + " " + remoteSrcFileLength + " " + remoteSrcFile);
        this.controlChannel.write(eretCmd);
        this.transferRunSingleThread(destination.controlChannel, mListener);
    }

    protected void checkGridFTPSupport() throws IOException, ServerException {
        FeatureList fl = this.getFeatureList();
        if (!(fl.contains("PARALLEL") && fl.contains("ESTO") && fl.contains("ERET") && fl.contains("SIZE"))) {
            throw new ServerException(3);
        }
    }

    public void setDataChannelAuthentication(DataChannelAuthentication type) throws IOException, ServerException {
        Command cmd = new Command("DCAU", type.toFtpCmdArgument());
        try {
            this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.dataChannelAuthentication = type;
        this.gLocalServer.setDataChannelAuthentication(type);
    }

    public void setLocalNoDataChannelAuthentication() {
        this.gLocalServer.setDataChannelAuthentication(DataChannelAuthentication.NONE);
    }

    public DataChannelAuthentication getDataChannelAuthentication() {
        return this.gSession.dataChannelAuthentication;
    }

    public void setDataChannelProtection(int protection) throws IOException, ServerException {
        String protectionStr = null;
        switch (protection) {
            case 1: {
                protectionStr = "C";
                break;
            }
            case 2: {
                protectionStr = "S";
                break;
            }
            case 3: {
                protectionStr = "E";
                break;
            }
            case 4: {
                protectionStr = "P";
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad protection: " + protection);
            }
        }
        Command cmd = new Command("PROT", protectionStr);
        try {
            this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.dataChannelProtection = protection;
        this.gLocalServer.setDataChannelProtection(protection);
    }

    public int getDataChannelProtection() {
        return this.gSession.dataChannelProtection;
    }

    public void setAuthorization(Authorization authorization) {
        ((GridFTPControlChannel)this.controlChannel).setAuthorization(authorization);
    }

    public Authorization getAuthorization() {
        return ((GridFTPControlChannel)this.controlChannel).getAuthorization();
    }

    public void setControlChannelProtection(int protection) {
        ((GridFTPControlChannel)this.controlChannel).setProtection(protection);
    }

    public int getControlChannelProtection() {
        return ((GridFTPControlChannel)this.controlChannel).getProtection();
    }

    public void get(String remoteFileName, File localFile) throws IOException, ClientException, ServerException {
        if (this.gSession.transferMode == 3) {
            FileRandomIO sink = new FileRandomIO(new RandomAccessFile(localFile, "rw"));
            this.get(remoteFileName, sink, null);
        } else {
            super.get(remoteFileName, localFile);
        }
    }

    public void put(File localFile, String remoteFileName, boolean append) throws IOException, ServerException, ClientException {
        if (this.gSession.transferMode == 3) {
            FileRandomIO source = new FileRandomIO(new RandomAccessFile(localFile, "r"));
            this.put(remoteFileName, source, null, append);
        } else {
            super.put(localFile, remoteFileName, append);
        }
    }

    public String checksum(ChecksumAlgorithm algorithm, long offset, long length, String file) throws IOException, ServerException {
        String arguments = algorithm.toFtpCmdArgument() + " " + String.valueOf(offset) + " " + String.valueOf(length) + " " + file;
        Command cmd = new Command("CKSM", arguments);
        Reply reply = null;
        try {
            reply = this.controlChannel.execute(cmd);
            return reply.getMessage();
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

